/************************************************************************************
* This header file is provided as part of the interface to the FreeScale 802.15.4
* MAC and PHY layer.
*
* This file contains initialization related functionality.
*
* Author(s): Jesper Thomsen, Knud Dyring-Olsen
*
* (c) Copyright 2004, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
************************************************************************************/

#ifndef _HPRFGW_RFMACPHYINIT_H_
#define _HPRFGW_RFMACPHYINIT_H_

  // The platform configuration file must be included for
  // gVersionStringCapability_d, gVersionStringBegin_d and gVersionStringEnd_d
#include "hprfgw_rfPlatformToMacPhyConfig.h"

  // Max 4 characters
#define Database_Label_Version	"106P"
#define MAC_Version_No		"106P"
#define PHY_Version_No		"106P"

/*	hs_tag
#if gVersionStringCapability_d

#pragma gVersionStringMacBegin_d
extern const uint8_t Freescale_Copyright[54];
extern const uint8_t Firmware_Database_Label[40];
extern const uint8_t MAC_Version[47];
#pragma gVersionStringMacEnd_d

#pragma gVersionStringPhyBegin_d
extern const uint8_t PHY_Version[47];
#pragma gVersionStringPhyEnd_d

#endif // gVersionStringCapability_d
*/

/************************************************************************************
* Stack init function called from platform upon reset. 
*
* Interface assumptions:
*   Typically called from Init_802_15_4() in platform
*
* Return value:
*   None
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   030505   JT        Created
*
************************************************************************************/
void MacPhyInit_Initialize
(
  bool_t relaxedTiming,       // Specifies if the MAC PHY should run with relaxed
                              // timing (LIFS/SIFS) due to a platform/mcu/clock 
                              // frequency timing issue.
  uint16_t phyRfCalibration   // MSB = CCA Energy detect threshold: abs(power in dBm)*2,
                              //       0x96=-75dBm
                              // LSB = Power compensation Offset added to RSSI. 
                              //       Typically 0x74 FFJ/JK 13/01/04 (Abel 013)
);

/************************************************************************************
* Writes the 8 byte IEEE extended address.
*
* Interface assumptions:
*   None
*
* Return value:
*   None
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   230505   KDO        Created
*
************************************************************************************/
void MacPhyInit_WriteExtAddress
(
  uint8_t *pExtendedAddress // A pointer to the 8 byte IEEE address. The address is
                            // copied into local MAC RAM.
);

/************************************************************************************
* Reads the 8 byte IEEE extended address.
*
* Interface assumptions:
*   None
*
* Return value:
*   A pointer to the extended address.
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   230505   KDO        Created
*
************************************************************************************/
uint8_t *MacPhyInit_ReadExtAddress(void);


#endif